# Descent into Madness User Manual

## Introduction

### The Story

One dark and stormy night you find yourself walking home alone on the narrow path through the woods. Suddenly, you hear the sound of something rushing through the air and – WHAM – you are hit on the back of the head, hard. You awaken to find yourself strapped to an operating table. You can’t move! Where are you? Why are you there? How do you get out? These are the questions you must answer as you navigate your way through your Descent into Madness.

### Who Can Play?

If we have done our job correctly, Descent into Madness will play out like an elaborate horror adventure story. Due to the somewhat scary sound effects and suggestions of violence (you get to kill monsters!), our primary target audience is ages 12 and up. However, anybody who finds this game exciting is welcome to play! Our goal was to design an enjoyable and accessible game for all children within the target age group; hence, the game may be played using only audio clues.

### Requirements

The maintainer of this updated fork of the original tests and programs this game on Linux so it is the most extensively tested platform. A Windows build is also provided and a build for apple computers is coming soon.

## Administration

### Downloading

Descent Into Madness is available for free at this website: http://www.cs.unc.edu/Research/assist/. Click on the link, and follow the instructions for downloading the game.

### Installation

If on Windows, unzip the downloaded directory and run "descent.exe" from the folder to play. If on Linux, make sure you have python3 and pygame installed on your machine and run "python3 Main.py".

## Playing Descent into Madness

### Keyboard Inputs

Arrow Keys
    • While playing the game, use RIGHT or LEFT arrow keys to scroll through options.
    • Use all four arrow keys in certain timing-based puzzles; instructions will be provided before each puzzle

Esc Key
    • Hitting the Esc key will cancel any choice you have just made.

SPACE Bar
    • Use to select a menu choice
    • Used to fire your weapon in certain parts of the game

### The Menu

When the game is started, a menu screen appears after a short music prelude. The menu options are read out to you:

    1. New Game
    2. Load Game
        3. Quit

Use the arrow keys to move between the choices, and hit SPACE Bar to select an option.

1. New Game

	You will begin a new game. A short preface will set up the story, and then the narrator will inform you that you are strapped to a table in an Operating Room.

2. Load Game

	You can save your progress during the game, and you can resume your game by choosing this option at the main menu. After you select this option, you are asked to “Choose a Slot”. Choose the slot number that you saved your game to begin where you left off last time.

3. Quit
	
	Selecting this exits the game.

### Playing the Game

If you have chosen a new game, the story begins. You awaken to find yourself strapped to an operating table. Clues scattered throughout the game will allow you to piece together the full story of why you are there and what you must do to get out. Solve puzzles to obtain new items and progress to new rooms. At every part of the game, you have three options that you may choose from: Move, Use Item, and Examine.

#### Move

Moving allows you to traverse between rooms in the mansion. Select Move by hitting the SPACE bar when the narrator says “Move.” A subset menu will be read by the narrator, indicating to which rooms you may move. Sometimes you will have to solve a puzzle before you are allowed to leave a certain room.

#### Use Item

Select Use Item by hitting the SPACE bar when the narrator says “Use Item.” The narrator will then ask you which item you would like to use, and you can scroll through the items in your inventory. You have an unlimited inventory, so you can take any item that you encounter during the game. You may also use yourself as an item. After you select an item to use, the narrator will ask you on which object you would like to use the item. The narrator will only read objects in the room on which you may use an item; however, not all objects require an item to be used on them.

A special function of the game involving Use Item is saving your progress. Scattered throughout the mansion are several journals available for this process. Simply use yourself on the journal, and the narrator will ask you which slot you would like to save your game in. Choose a slot, and your progress and item inventory will be saved. The next time you play the game, you can choose “Load Game” from the menu, choose a slot, and you will start wherever you last saved the game.

#### Examine

Examine is the most important option in the game. Select Examine by hitting the SPACE bar when the narrator says “Examine.” When you choose Examine, the narrator will ask you what you want to Examine. The first choice will always be the room that you are in, followed by each item that is in the room. When you first enter a room, choose Examine to learn the details of the room, including what items are in the room. Then Examine individual items to learn how they can be used. In order to take an item, you must Examine it first, and then the narrator will ask you if you want to take the item. Hit SPACE to choose “Yes” and the item will become part of your inventory.  

It is highly recommended to Examine everything! When you first enter a room, always Examine it to learn the items in the room. Then Examine each item: doing so will give you clues to how the item should be used.

Additional Information

If you wish to contact the developers, try out our other games, or if you desire more information on Sounds Like Fun, please visit http://wwwx.cs.unc.edu/~gb/cgi-bin/sliki/SoundsLikeFun.

Thanks for playing Descent Into Madness!


